# Wyświetlenie komunikatu
Write-Host "Skrypt doda użytkownika (user) i administratora (myadmin)"
$confirmation = Read-Host "Kontynuować? (T/N)"

# Normalizacja odpowiedzi użytkownika (ignorowanie wielkości liter)
switch ($confirmation.ToUpper()) {
    "T" { Write-Host "Kontynuuję skrypt..." }
    "N" { Write-Host "Skrypt został przerwany."; return }
    default { Write-Host "Niepoprawna odpowiedź. Skryp został przerwany."; return }
}

$adminPasswordInput = Read-Host -AsSecureString "Podaj haslo dla konta administratora (myadmin)"
New-LocalUser -Name "myadmin" -Password $adminPasswordInput -FullName "Administrator (myadmin)" -Description "Administrator komputera" -AccountNeverExpires
Add-LocalGroupMember -Group "Administratorzy" -Member "myadmin"

$userPasswordInput = Read-Host -AsSecureString "Podaj haslo dla konta użytkownika (user)"
New-LocalUser -Name "user" -Password $userPasswordInput -FullName "User" -Description "Standard user account" -AccountNeverExpires

# SID dla grupy "Users"
$usersGroupSID = "S-1-5-32-545"
Add-LocalGroupMember -SID $usersGroupSID -Member "user"

# Edycja rejestru - Usuń wartość LaunchUserOOBE w HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\OOBE
$regKeyOOBE = "HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\OOBE"
if (Test-Path $regKeyOOBE) {
    Set-ItemProperty -Path $regKeyOOBE -Name "BypassNRO" -Value "1"
    Remove-ItemProperty -Path $regKeyOOBE -Name "LaunchUserOOBE" -ErrorAction SilentlyContinue
}

# Wyłączenie automatycznego logowania (w rejestrze)
$regKeyWinlogon = "HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon"
if (Test-Path $regKeyWinlogon) {
    Set-ItemProperty -Path $regKeyWinlogon -Name "AutoAdminLogon" -Value "0"
    Set-ItemProperty -Path $regKeyWinlogon -Name "AutoLogonSID" -Value ""
    Set-ItemProperty -Path $regKeyWinlogon -Name "DefaultUserName" -Value "User"
    Set-ItemProperty -Path $regKeyWinlogon -Name "DefaultPassword" -Value ""
    Set-ItemProperty -Path $regKeyWinlogon -Name "EnableFirstLogonAnimation" -Value 0
}

Write-Host "Zmiany w rejestrze zostały zastosowane."

# Sprawdź, czy konto "DEFAULTUSER0" jest zalogowane
$defaultUser = Get-WmiObject -Class Win32_ComputerSystem
if ($defaultUser.UserName -eq "DEFAULTUSER0") {
    # Jeśli "DEFAULTUSER0" jest zalogowany, wyloguj go
    shutdown.exe /l
    Start-Sleep -Seconds 5  # Czekaj 5 sekund, aby proces wylogowania zakończył się
}

# Usuń konto "DEFAULTUSER0"
Remove-LocalUser -Name "DEFAULTUSER0"

Write-Host "Konta zostały utworzone, a konto DEFAULTUSER0 zostało usunięte."
Write-Host "Restartujemy komputer . . . . . ."
Sleep 1
Write-Host "Paaaaaa . . . . . ."
# Restart-Computer

